(ns antistock.db.twitter.tweets-quotes
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all :exclude [deftable]]
            [datumbazo.table :refer [deftable]]))

(deftable tweets-quotes
  "The join table between Twitter tweets and stock quotes."
  (table :twitter.tweets-quotes)
  (column :tweet-id :integer :not-null? true :references :twitter.tweets/id)
  (column :quote-id :integer :not-null? true :references :quotes/id)
  (primary-key :tweet-id :quote-id))
