(ns antistock.db.twitter.tweets
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all :exclude [deftable]]
            [antistock.db.twitter.users :as users]
            [antistock.db.twitter.hash-tags :as hash-tags]
            [datumbazo.table :refer [deftable]]
            [com.rpl.specter :as sp]
            [schema.core :as s]
            [clojure.set :as set]))

(deftable tweets
  "The Twitter tweets database table."
  (table :twitter.tweets)
  (column :id :bigserial :primary-key? true)
  (column :user-id :bigint :not-null? true :references :twitter.users/id)
  (column :retweeted :boolean :not-null? true :default false)
  (column :retweet-count :integer)
  (column :text :text :not-null? true)
  (column :sentiment :integer)
  (column :favorited :boolean :not-null? true :default false)
  (column :in-reply-to-status-id :integer)
  (column :in-reply-to-user-id :integer)
  (column :in-reply-to-screen-name :text)
  (column :created-at :timestamp-with-time-zone :not-null? true :default '(now))
  (column :updated-at :timestamp-with-time-zone :not-null? true :default '(now))
  (belongs-to :user :schema :twitter))
