(ns antistock.db.twitter.hash-tags
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all :exclude [deftable]]
            [datumbazo.table :refer [deftable]]))

(deftable hash-tags
  "The Twitter hash tags table."
  (table :twitter.hash-tags)
  (column :id :bigserial :primary-key? true)
  (column :name :citext :not-null? true)
  (column :created-at :timestamp-with-time-zone :not-null? true :default '(now))
  (column :updated-at :timestamp-with-time-zone :not-null? true :default '(now))
  (primary-key :name))
