(ns antistock.db.test
  (:require [antistock.config.test :as test-config]
            [antistock.db.quotes :as quotes]
            [antistock.db.system :refer [with-db]]
            [antistock.util :refer [immigrate]]
            [datumbazo.core :refer [with-connection]]))

(def config test-config/config)
(def env test-config/env)

(defmacro with-test-db [[db-sym] & body]
  `(with-db [db# (:db (config))]
     (with-connection [~db-sym db#]
       ~@body)))

(defn armh [db]
  (quotes/quote-by-symbol db "ARMH"))

(defn apple [db]
  (quotes/quote-by-symbol db "AAPL"))

(defn google [db]
  (quotes/quote-by-symbol db "GOOG"))

(defn aapl [db]
  (quotes/quote-by-symbol db "AAPL"))

(defn goog [db]
  (quotes/quote-by-symbol db "GOOG"))

(def example-tweet
  {:id-str "270215856938696705",
   :entities
   {:hashtags [{:text "GOOG"}]
    :urls
    [{:display-url "uk.advfn.com/news/DJN/2012/…",
      :url "http://t.co/RnYDxDEC",
      :indices [68 88],
      :expanded-url
      "http://uk.advfn.com/news/DJN/2012/article/55077628?xref=newsalerttweet"}],
    :user-mentions
    [{:name "Bosco So"
      :id_str "14792670"
      :id 14792670
      :indices [46 58]
      :screen-name "boscomonkey"}]
    :symbols
    [{:text "GOOG", :indices [1 4]}]}
   :text "$GOOG - Facebook, Yahoo in Talks on Search Collaboration - #GOOG Newspaper http://t.co/RnYDxDEC",
   :in-reply-to-status-id nil,
   :coordinates nil,
   :in-reply-to-status-id-str nil,
   :contributors nil,
   :tracks #{"$GOOG"},
   :in-reply-to-user-id-str nil,
   :retweeted false,
   :truncated false,
   :in-reply-to-screen-name nil,
   :possibly-sensitive-editable true,
   :geo nil,
   :place nil,
   :updated-at #inst "2012-11-18T17:24:34.189-00:00",
   :created-at #inst "2012-11-18T17:24:15.000-00:00",
   :in-reply-to-user-id nil,
   :user
   {:id-str "409356863",
    :listed-count 0,
    :default-profile-image true,
    :time-zone nil,
    :protected false,
    :profile-background-image-url
    "http://a0.twimg.com/images/themes/theme1/bg.png",
    :profile-background-color "C0DEED",
    :following nil,
    :utc-offset nil,
    :geo-enabled false,
    :name "win some",
    :location "england",
    :profile-text-color "333333",
    :profile-image-url
    "http://a0.twimg.com/sticky/default_profile_images/default_profile_6_normal.png",
    :follow-request-sent nil,
    :favourites-count 0,
    :contributors-enabled false,
    :friends-count 77,
    :followers-count 6,
    :lang "en",
    :url nil,
    :notifications nil,
    :default-profile true,
    :is-translator false,
    :updated-at #inst "2012-11-18T17:24:34.147-00:00",
    :created-at #inst "2011-11-10T16:36:41.000-00:00",
    :screen-name "some_win",
    :profile-image-url-https
    "https://si0.twimg.com/sticky/default_profile_images/default_profile_6_normal.png",
    :profile-sidebar-border-color "C0DEED",
    :profile-background-image-url-https
    "https://si0.twimg.com/images/themes/theme1/bg.png",
    :retweet-count 0,
    :possibly-sensitive false,
    :profile-background-tile false,
    :profile-link-color "0084B4",
    :profile-sidebar-fill-color "DDEEF6",
    :statuses-count 7738,
    :verified false,
    :id 409356863,
    :profile-use-background-image true,
    :description ""},
   :retweet-count 0,
   :possibly-sensitive false,
   :favorited false,
   :source
   "<a href=\"http://www.advfn.com\" rel=\"nofollow\">ADVFN News Alert</a>",
   :id 270215856938696705
   :best-category "negative"})

(def example-tweets
  [{:retweet-count 0,
    :in-reply-to-user-id 1484891485,
    :filter-level "medium",
    :coordinates nil,
    :in-reply-to-user-id-str "1484891485",
    :place nil,
    :geo nil,
    :tracks #{"Apple"},
    :entities
    {:media
     [{:sizes
       {:large {:resize "fit", :h 420, :w 560},
        :medium {:resize "fit", :h 420, :w 560},
        :thumb {:resize "crop", :h 150, :w 150},
        :small {:resize "fit", :h 255, :w 340}},
       :display-url "pic.twitter.com/YN9zGzAHH1",
       :expanded-url
       "http://twitter.com/CCArthouse/status/539482198626537473/photo/1",
       :type "photo",
       :id-str "539482196567150592",
       :id 539482196567150592,
       :url "http://t.co/YN9zGzAHH1",
       :indices [45 67],
       :media-url-https "https://pbs.twimg.com/media/B3ygMxEIUAA-WMT.jpg",
       :media-url "http://pbs.twimg.com/media/B3ygMxEIUAA-WMT.jpg"}],
     :symbols [],
     :user-mentions
     [{:indices [0 11],
       :id-str "1484891485",
       :id 1484891485,
       :name "ADF",
       :screen-name "AlinaDal_F"}],
     :urls [],
     :trends [],
     :hashtags []},
    :id-str "539482198626537473",
    :in-reply-to-status-id nil,
    :source
    "<a href=\"http://twitter.com\" rel=\"nofollow\">Twitter Web Client</a>",
    :extended-entities
    {:media
     [{:sizes
       {:large {:resize "fit", :h 420, :w 560},
        :medium {:resize "fit", :h 420, :w 560},
        :thumb {:resize "crop", :h 150, :w 150},
        :small {:resize "fit", :h 255, :w 340}},
       :display-url "pic.twitter.com/YN9zGzAHH1",
       :expanded-url
       "http://twitter.com/CCArthouse/status/539482198626537473/photo/1",
       :type "photo",
       :id-str "539482196567150592",
       :id 539482196567150592,
       :url "http://t.co/YN9zGzAHH1",
       :indices [45 67],
       :media-url-https "https://pbs.twimg.com/media/B3ygMxEIUAA-WMT.jpg",
       :media-url "http://pbs.twimg.com/media/B3ygMxEIUAA-WMT.jpg"}]},
    :lang "en",
    :possibly-sensitive false,
    :id 539482198626537473,
    :contributors nil,
    :truncated false,
    :retweeted false,
    :timestamp-ms "1417457553904",
    :in-reply-to-screen-name "AlinaDal_F",
    :in-reply-to-status-id-str nil,
    :favorited false,
    :created-at #inst "2014-12-01T18:12:33.000-00:00",
    :user
    {:description
     "https://www.facebook.com/pages/Colour-Circle-Arthouse/404601802921068 Progressive art and design \n loaded with funky, sophisticated and im
aginative ideas.",
     :default-profile-image false,
     :follow-request-sent nil,
     :friends-count 1231,
     :profile-background-image-url
     "http://pbs.twimg.com/profile_background_images/378800000162508388/Phyk78Fa.jpeg",
     :is-translator false,
     :utc-offset nil,
     :name "ColourCircleArthouse",
     :profile-sidebar-fill-color "DDEEF6",
     :profile-sidebar-border-color "FFFFFF",
     :statuses-count 6339,
     :id-str "737620518",
     :following nil,
     :profile-background-color "C0DEED",
     :lang "en",
     :profile-background-image-url-https
     "https://pbs.twimg.com/profile_background_images/378800000162508388/Phyk78Fa.jpeg",
     :followers-count 2088,
     :profile-background-tile true,
     :notifications nil,
     :screen-name "CCArthouse",
     :id 737620518,
     :url "http://colourcirclearthouse.co.uk/",
     :profile-use-background-image true,
     :protected false,
     :listed-count 32,
     :profile-link-color "0084B4",
     :geo-enabled false,
     :favourites-count 276,
     :profile-banner-url
     "https://pbs.twimg.com/profile_banners/737620518/1406811039",
     :created-at #inst "2012-08-04T23:38:55.000-00:00",
     :location "UK",
     :profile-image-url-https
     "https://pbs.twimg.com/profile_images/523448293854945280/ZTGWMqlw_normal.jpeg",
     :contributors-enabled false,
     :profile-image-url
     "http://pbs.twimg.com/profile_images/523448293854945280/ZTGWMqlw_normal.jpeg",
     :profile-text-color "333333",
     :default-profile false,
     :verified false,
     :time-zone nil},
    :favorite-count 0,
    :text
    "@AlinaDal_F Monday cca -Who Ate Dee Apple?.' http://t.co/YN9zGzAHH1"}])
