-- Deploy twitter-credentials

BEGIN;

CREATE TABLE twitter.credentials (
  id serial PRIMARY KEY,
  "application-id" INTEGER NOT NULL REFERENCES twitter.applications(id),
  "consumer-key" TEXT NOT NULL UNIQUE,
  "consumer-secret" TEXT NOT NULL,
  "access-token" TEXT NOT NULL,
  "access-token-secret" TEXT NOT NULL,
  "created-at" timestamp with time zone NOT NULL DEFAULT now(),
  "updated-at" timestamp with time zone NOT NULL DEFAULT now()
);

CREATE TRIGGER "twitter-credentials-created-at-trigger"
  BEFORE INSERT ON twitter.credentials FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER "twitter-credentials-updated-at-trigger"
  BEFORE UPDATE ON twitter.credentials FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
