-- Deploy twitter-applications

BEGIN;

CREATE TABLE twitter.applications (
  id bigserial PRIMARY KEY,
  "user-id" bigint NOT NULL REFERENCES twitter.users(id),
  "name" TEXT UNIQUE NOT NULL,
  "description" TEXT,
  "url" TEXT,
  "created-at" timestamp with time zone NOT NULL DEFAULT now(),
  "updated-at" timestamp with time zone NOT NULL DEFAULT now()
);

CREATE TRIGGER "twitter-applications-created-at-trigger"
  BEFORE INSERT ON twitter.applications FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER "twitter-applications-updated-at-trigger"
  BEFORE UPDATE ON twitter.applications FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
