-- Revert recreate-wikipedia-page-views-table

BEGIN;

DROP TABLE wikipedia.page_views;

CREATE TABLE wikipedia.page_views (
  id SERIAL PRIMARY KEY,
  page_id INTEGER NOT NULL REFERENCES wikipedia.pages(id) ON DELETE CASCADE,
  date TIMESTAMP WITH TIME ZONE NOT NULL,
  count INTEGER NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_page_views_page_id_index ON wikipedia.page_views (page_id);
CREATE INDEX wikipedia_page_views_date_index ON wikipedia.page_views (date);
CREATE UNIQUE INDEX wikipedia_page_views_page_id_date_index ON wikipedia.page_views (page_id, date);

CREATE TRIGGER wikipedia_page_views_created_at_trigger
  BEFORE INSERT ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_page_views_updated_at_trigger
  BEFORE UPDATE ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
