(ns antistock.db.exchanges
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all]))

(deftable exchanges
  "The stock exchanges database table."
  (column :id :serial :primary-key? true)
  (column :country-id :integer :references :countries/id)
  (column :name :citext :not-null? true :unique? true)
  (column :suffix :citext)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()"))

(defn amex
  "Returns the American Stock Exchange."
  [db] (exchange-by-id db 3))

(defn nasdaq
  "Returns the NASDAQ Stock Exchange."
  [db] (exchange-by-id db 2))

(defn nyse
  "Returns the New York Stock Exchange."
  [db] (exchange-by-id db 1))

(defn exchanges-like-name [db name]
  (select db [:*]
    (from :exchanges)
    (where `(like :name ~(str "%" name "%")))))
