-- Deploy remove-wikipedia-projects

BEGIN;

DROP TABLE wikipedia.page_views CASCADE;
DROP TABLE wikipedia.projects CASCADE;

CREATE TABLE wikipedia.page_views (
  id SERIAL PRIMARY KEY,
  page_id INTEGER NOT NULL REFERENCES wikipedia.pages(id) ON DELETE CASCADE,
  language_id INTEGER NOT NULL REFERENCES languages(id) ON DELETE CASCADE,
  count INTEGER NOT NULL,
  date DATE NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX wikipedia_page_views_page_id_index ON wikipedia.page_views (page_id);
CREATE INDEX wikipedia_page_views_language_id_index ON wikipedia.page_views (language_id);
CREATE INDEX wikipedia_page_views_date_index ON wikipedia.page_views (date);
CREATE UNIQUE INDEX wikipedia_page_views_page_id_language_id_date ON wikipedia.page_views (page_id, language_id, date);

CREATE TRIGGER wikipedia_page_views_created_at_trigger
  BEFORE INSERT ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER wikipedia_page_views_updated_at_trigger
  BEFORE UPDATE ON wikipedia.page_views FOR EACH ROW EXECUTE PROCEDURE set_updated_at();


COMMIT;
