-- Deploy features-view

BEGIN;

CREATE MATERIALIZED VIEW ml.features AS
     SELECT prices.date,
            prices.quote_id,
            prices.open,
            prices.close,
            prices.high,
            prices.low,
            prices.volume,
            prices.adj_close,
            prices.daily_return,
            coalesce(tday.count, 0) AS tday,
            coalesce(tuday.count, 0) AS tuday,
            coalesce(rtid.count, 0) AS rtid,
            coalesce(rtu.count, 0) AS rtu,
            coalesce(sentneg.count, 0) AS sentneg,
            coalesce(sentneut.count, 0) AS sentneut,
            coalesce(sentpos.count, 0) AS sentpos,
            coalesce(sentvneg.count, 0) AS sentvneg,
            coalesce(sentvpos.count, 0) AS sentvpos,
            coalesce(tgeo.count, 0) AS tgeo,
            coalesce(thtg.count, 0) AS thtg,
            coalesce(tid.count, 0) AS tid,
            coalesce(turl.count, 0) AS turl,
            coalesce(tusm.count, 0) AS tusm,
            coalesce(uflw.count, 0) AS uflw,
            coalesce(ufrn.count, 0) AS ufrn,
            coalesce(uid.count, 0) AS uid
       FROM prices
       JOIN ml.tday
         ON ml.tday.date = prices.date
       JOIN ml.tuday
         ON ml.tuday.date = prices.date
  LEFT JOIN ml.rtid
         ON ml.rtid.date = prices.date
        AND ml.rtid.quote_id = prices.quote_id
  LEFT JOIN ml.rtu
         ON ml.rtu.date = prices.date
        AND ml.rtu.quote_id = prices.quote_id
  LEFT JOIN ml.sentneg
         ON ml.sentneg.date = prices.date
        AND ml.sentneg.quote_id = prices.quote_id
  LEFT JOIN ml.sentneut
         ON ml.sentneut.date = prices.date
        AND ml.sentneut.quote_id = prices.quote_id
  LEFT JOIN ml.sentpos
         ON ml.sentpos.date = prices.date
        AND ml.sentpos.quote_id = prices.quote_id
  LEFT JOIN ml.sentvneg
         ON ml.sentvneg.date = prices.date
        AND ml.sentvneg.quote_id = prices.quote_id
  LEFT JOIN ml.sentvpos
         ON ml.sentvpos.date = prices.date
        AND ml.sentvpos.quote_id = prices.quote_id
  LEFT JOIN ml.tgeo
         ON ml.tgeo.date = prices.date
        AND ml.tgeo.quote_id = prices.quote_id
  LEFT JOIN ml.thtg
         ON ml.thtg.date = prices.date
        AND ml.thtg.quote_id = prices.quote_id
  LEFT JOIN ml.tid
         ON ml.tid.date = prices.date
        AND ml.tid.quote_id = prices.quote_id
  LEFT JOIN ml.turl
         ON ml.turl.date = prices.date
        AND ml.turl.quote_id = prices.quote_id
  LEFT JOIN ml.tusm
         ON ml.tusm.date = prices.date
        AND ml.tusm.quote_id = prices.quote_id
  LEFT JOIN ml.uflw
         ON ml.uflw.date = prices.date
        AND ml.uflw.quote_id = prices.quote_id
  LEFT JOIN ml.ufrn
         ON ml.ufrn.date = prices.date
        AND ml.ufrn.quote_id = prices.quote_id
  LEFT JOIN ml.uid
         ON ml.uid.date = prices.date
        AND ml.uid.quote_id = prices.quote_id;

CREATE UNIQUE INDEX ml_features_date_quote_id_idx ON ml.features (date, quote_id);
CREATE INDEX ml_features_quote_id_idx ON ml.features (quote_id);

COMMIT;
