-- Deploy create-sectors-table

BEGIN;

CREATE TABLE sectors (
  id serial PRIMARY KEY,
  name citext UNIQUE NOT NULL,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX sectors_name_idx ON sectors USING GIN(to_tsvector('english', name));

CREATE TRIGGER sectors_created_at_trigger
  BEFORE INSERT ON sectors FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER sectors_updated_at_trigger
  BEFORE UPDATE ON sectors FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
