-- Deploy create-twitter-tweets-table

BEGIN;

CREATE TABLE twitter.tweets (
  id bigint PRIMARY KEY,
  user_id bigint REFERENCES twitter.users(id) ON DELETE CASCADE,
  in_reply_to_status_id bigint,
  in_reply_to_user_id bigint,
  in_reply_to_screen_name text,
  favorited boolean NOT NULL DEFAULT false,
  retweeted boolean NOT NULL DEFAULT false,
  retweet_count integer NOT NULL DEFAULT 0,
  text text NOT NULL,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE TRIGGER twitter_tweets_created_at_trigger
  BEFORE INSERT ON twitter.tweets FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER twitter_tweets_updated_at_trigger
  BEFORE UPDATE ON twitter.tweets FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
