-- Deploy create-exchanges-table

BEGIN;

CREATE TABLE exchanges (
  id serial PRIMARY KEY,
  country_id INTEGER NOT NULL REFERENCES countries(id) ON DELETE CASCADE,
  name citext UNIQUE NOT NULL,
  suffix citext,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX exchanges_name_idx ON exchanges USING GIN(to_tsvector('english', name));

CREATE TRIGGER exchanges_created_at_trigger
  BEFORE INSERT ON exchanges FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER exchanges_updated_at_trigger
  BEFORE UPDATE ON exchanges FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
