(ns antistock.db.events
  (:refer-clojure :exclude [distinct group-by update])
  (:require [clj-time.core :refer [now minus years days]]
            [clj-time.coerce :refer [to-date-time]]
            [antistock.db.quotes :as quotes]
            [datumbazo.core :refer :all]))

(defquery price-before-changed
  "Returns events where close drops by `money` within a day."
  [db money & {:keys [start end quotes]}]
  (let [start (or start (minus (now) (years 1)))
        end (or end (now))
        quotes (or quotes (quotes/quotes db))]
    (select db [:* (as '(- :close :close-before) :money)]
      (from (as (select db [:* (as '((lag :close) over (partition by :quote-id order by :date)) :close-before)]
                  (from :prices))
                :p))
      (where `(and (is-not-null :close)
                   (< (- :close :close-before) ~money)
                   (>= :date ~(to-date-time start))
                   (<= :date ~(to-date-time end))))
      (if-not (empty? quotes)
        (where `(in :quote-id ~(map :id quotes)) :and)))))
