-- Deploy create-industries-table

BEGIN;

CREATE TABLE industries (
  id serial PRIMARY KEY,
  name citext UNIQUE NOT NULL,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE INDEX industries_name_idx ON industries USING GIN(to_tsvector('english', name));

CREATE TRIGGER industries_created_at_trigger
  BEFORE INSERT ON industries FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER industries_updated_at_trigger
  BEFORE UPDATE ON industries FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
