-- Deploy create-languages-table

BEGIN;

CREATE TABLE languages (
  id SERIAL PRIMARY KEY,
  name CITEXT UNIQUE NOT NULL,
  family CITEXT NOT NULL,
  iso_639_1 CITEXT NOT NULL UNIQUE,
  iso_639_2 CITEXT NOT NULL UNIQUE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX languages_name_fulltext_index ON languages USING gin(to_tsvector('english', name));

CREATE TRIGGER languages_created_at_trigger
  BEFORE INSERT ON languages FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER languages_updated_at_trigger
  BEFORE UPDATE ON languages FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
