-- Deploy create-hash-tags-table

BEGIN;

CREATE TABLE twitter.hash_tags (
  id bigserial PRIMARY KEY,
  name citext NOT NULL UNIQUE,
  created_at timestamp with time zone NOT NULL DEFAULT now(),
  updated_at timestamp with time zone NOT NULL DEFAULT now()
);

CREATE TRIGGER twitter_hash_tags_created_at_trigger
  BEFORE INSERT ON twitter.hash_tags FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER twitter_hash_tags_updated_at_trigger
  BEFORE UPDATE ON twitter.hash_tags FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
