-- Deploy add-yahoo-live-table

BEGIN;

CREATE TABLE yahoo.live (
  id SERIAL PRIMARY KEY,
  quote_id INTEGER NOT NULL REFERENCES quotes(id) ON DELETE CASCADE,
  "1_year_target_price" NUMERIC,
  "200_day_moving_average" NUMERIC,
  "50_day_moving_average" NUMERIC,
  "52_week_high" NUMERIC,
  "52_week_low" NUMERIC,
-- 52-week-range NUMRANGE,
  "after_hours_change_real_time" NUMERIC,
  -- "annualized_gain" NUMERIC,
  "ask" NUMERIC,
  "ask_real_time" NUMERIC,
  "ask_size" INTEGER,
  "avg_daily_vol" BIGINT,
  "bid" NUMERIC,
  "bid_real_time" NUMERIC,
  "bid_size" BIGINT,
  "book_value" NUMERIC,
  change NUMERIC,
  "change_from_200_day_moving_average" NUMERIC,
  "change_from_50_day_moving_average" NUMERIC,
  "change_from_52_week_high" NUMERIC,
  "change_from_52_week_low" NUMERIC,
  "change_in_percent" NUMERIC,
  -- "change-percent" NUMERIC,
  -- "change-percent-real-time" NUMERIC,
  "change_real_time" NUMERIC,
  -- "commision" NUMERIC,
  "day_high" NUMERIC,
  "day_low" NUMERIC,
  -- "day-range" NUMERIC,
  -- "day-range-real-time" NUMERIC,
  -- "day-value-change" NUMERIC,
  -- "day-value-change-real-time" NUMERIC,
  "dividend_pay_date" TIMESTAMP WITH TIME ZONE,
  "dividend_share" NUMERIC,
  "dividend_yield" NUMERIC,
  "earnings_share" NUMERIC,
  "ebitda" NUMERIC,
  "eps_estimate_current_year" NUMERIC,
  "eps_estimate_next_quarter" NUMERIC,
  "eps_estimate_next_year" NUMERIC,
  "ex_dividend_date" TIMESTAMP WITH TIME ZONE,
  "float_shares" NUMERIC,
  "high_limit" NUMERIC,
  "holdings_gain" NUMERIC,
  -- "holdings-gain-percent" NUMERIC,
  -- "holdings-gain-percent-real-time" NUMERIC,
  "holdings_gain_real_time" NUMERIC,
  -- "holdings-value" NUMERIC,
  "holdings_value_real_time" NUMERIC,
  "last_trade_date" TIMESTAMP WITH TIME ZONE,
  "last_trade_price_only" NUMERIC,
  -- last-trade-real-time-with-time NUMERIC,
  "last_trade_size" INTEGER,
  "last_trade_time" TIMESTAMP WITH TIME ZONE,
  -- last-trade-with-time NUMERIC,
  "low_limit" NUMERIC,
  "market_cap" NUMERIC,
  "market_cap_real_time" NUMERIC,
  "more_info" TEXT,
  "name" TEXT,
  "notes" TEXT,
  "open" NUMERIC,
  "order_book_real_time" NUMERIC,
  "p_e_ratio" NUMERIC,
  "p_e_ratio_real_time" NUMERIC,
  "peg_ratio" NUMERIC,
  "percent_change_from_200_day_moving_average" NUMERIC,
  "percent_change_from_50_day_moving_average" NUMERIC,
  "percent_change_from_52_week_high" NUMERIC,
  "percent_change_from_52_week_low" NUMERIC,
  "previous_close" NUMERIC,
  "price_book" NUMERIC,
  "price_eps_estimate_current_year" NUMERIC,
  "price_eps_estimate_next_year" NUMERIC,
  "price_paid" NUMERIC,
  "price_sales" NUMERIC,
  -- shares-owned NUMERIC,
  "short_ratio" NUMERIC,
  -- stock-exchange NUMERIC,
  -- symbol NUMERIC,
  -- ticker-trend NUMERIC,
  "trade_date" DATE,
  "volume" NUMERIC,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  updated_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX yahoo_live_page_id_index ON yahoo.live (quote_id);
CREATE INDEX yahoo_live_edited_at_index ON yahoo.live (created_at);

CREATE TRIGGER yahoo_live_created_at_trigger
  BEFORE INSERT ON yahoo.live FOR EACH ROW EXECUTE PROCEDURE set_created_at();

CREATE TRIGGER yahoo_live_updated_at_trigger
  BEFORE UPDATE ON yahoo.live FOR EACH ROW EXECUTE PROCEDURE set_updated_at();

COMMIT;
