(ns antistock.db.system
  (:require [clojure.string :as str]
            [com.stuartsierra.component :as component]
            [datumbazo.core :as d]
            [sqlingvo.db :refer [postgresql]]))

(defn- hyphenate [s]
  (keyword (str/replace (name s) "_" "-")))

(defn- underscore [s]
  (str/replace (name s) "-" "_"))

(defn new-db [config]
  (assoc (d/new-db config)
         :sql-keyword hyphenate
         :sql-name underscore))

(defmacro with-component
  "Create a new component with `new-form`, bind the started component
  to `component-sym`, evaluate `body` and stop the component again."
  [[component-sym new-form] & body]
  `(let [component# (component/start ~new-form)
         ~component-sym component#]
     (try ~@body
          (finally (component/stop component#)))))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym (new-db ~config)]
     ~@body))
