(ns antistock.db.languages
  (:refer-clojure :exclude [distinct group-by update])
  (:require [datumbazo.core :refer :all]))

(deftable languages
  "The languages database table."
  (column :id :serial :primary-key? true)
  (column :name :citext :not-null? true :unique? true)
  (column :family :citext :not-null? true)
  (column :iso-639-1 :citext :not-null? true :unique? true)
  (column :iso-639-2 :citext :not-null? true :unique? true)
  (column :created-at :timestamp-with-time-zone :not-null? true :default "now()")
  (column :updated-at :timestamp-with-time-zone :not-null? true :default "now()"))

(defn german
  "Find the German language."
  [db] (language-by-iso-639-1 db "de"))

(defn english
  "Find the English language."
  [db] (language-by-iso-639-1 db "de"))
