(ns antistock.config.system
  (:require [antistock.config.core :as config]))

(defn api
  "Return the config for the API."
  [env]
  {:api (config/api env)
   :api-client (config/api-client env)
   :broker (config/broker env)
   :db (config/db env)})

(defn worker
  "Return the config for the worker."
  [env]
  {:api (config/api env)
   :api-client (config/api-client env)
   :broker (config/broker env)
   :db (config/db env)})

(defn tweetlogd
  "Return the config for the tweetlogd."
  [env]
  {:api-client (config/api-client env)
   :curator (config/curator env)
   :twitter (config/twitter env)})

(defn scheduler
  "Return the config for the scheduler."
  [env]
  {:api (config/api env)
   :api-client (config/api-client env)
   :broker (config/broker env)
   :db (config/db env)})

(defn config
  "Return the config for the Antistock system."
  [env]
  {:api (api env)
   :scheduler (scheduler env)
   :tweetlogd (tweetlogd env)
   :worker (worker env)})
