(ns antistock.config.schema
  (:require [schema.core :as s]))

(def Api
  "The schema for the API service."
  {:bind-address s/Str
   :bind-port s/Int})

(def ApiClient
  "The schema for the API client."
  {:scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Aws
  "The schema for the AWS service."
  {:access-key s/Str
   :account-number s/Str
   :secret-key s/Str})

(def Broker
  "The schema for the broker service."
  {:password s/Str
   :scheme (s/enum :amqp)
   :server-name s/Str
   :server-port s/Int
   :username s/Str
   :vhost s/Str})

(def Db
  "The schema for the database service."
  {:name s/Str
   :password s/Str
   :scheme (s/enum :postgresql)
   :server-name s/Str
   :server-port s/Int
   :user s/Str
   (s/optional-key :pool) (s/enum :bonecp :c3p0 nil)
   (s/optional-key :test) s/Bool})

(def Google
  "The schema for the database service."
  {:api-key s/Str
   :client-id s/Str
   :client-secret s/Str
   :redirect-uri s/Str})

(def Reload
  "The schema for the namespace reload service."
  {:disabled s/Bool
   :source-paths [s/Str]})

(def Twitter
  "The schema for the Twitter client."
  {:consumer-key s/Str
   :consumer-secret s/Str
   :access-token s/Str
   :access-token-secret s/Str})

(def Web
  "The schema for the web service."
  {:bind-address s/Str
   :bind-port s/Int})

(def Spark
  "The schema for Spark applications."
  {:app-name s/Str
   :master s/Str})

(def WebClient
  "The schema for the web client."
  {:scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Zookeeper
  "The schema for the Zookeeper service."
  {:password s/Str
   :server-name s/Str
   :server-port s/Int
   :username s/Str})

(def Config
  "The schema for the config."
  {:api Api
   :api-client ApiClient
   :aws Aws
   :broker Broker
   :db Db
   :google Google
   :reload Reload
   :twitter Twitter
   :web Web
   :web-client WebClient
   :zookeeper Zookeeper})
