(ns antistock.component
  (:require [com.stuartsierra.component :as component]))

(defn on-shutdown
  "Run the function `f` on JVM shutdown."
  [f]
  (.addShutdownHook (Runtime/getRuntime) (Thread. f)))

(defmacro with-component
  "Start the `component`, bind the started instance to
  `component-sym`, evaluate `body` and stop the component again."
  [[component-sym component] & body]
  `(let [component# (component/start ~component)
         ~component-sym component#]
     (try ~@body (finally (component/stop component#)))))
