(ns antistock.cli.wikipedia
  (:gen-class)
  (:require [antistock.config.core :refer [config]]
            [antistock.db :as db]
            [antistock.db.system :refer [with-db]]
            [antistock.time :refer [hourly-time-series]]
            [antistock.util :refer [crc-path indexed]]
            [antistock.wikipedia :as wikipedia]
            [antistock.wikipedia.edits :as edits]
            [antistock.wikipedia.languages :as languages]
            [antistock.cli.wikipedia.views :as views]
            [clojure.java.io :refer [file]]
            [clojure.tools.logging :refer [errorf infof]]
            [datumbazo.core :refer [with-connection]]
            [commandline.core :refer [print-help with-commandline]]
            [environ.core :refer [env]]))

(defn languages
  "import the Wikipedia languages into the database."
  [db args]
  (infof "Updating database with languages from Wikipedia.")
  (let [languages (languages/import-languages db)]
    (infof "%s languages successfully updated." (count languages))) )

(defn -main [& args]
  (let [[command & args] args]
    (with-db [db (:db (config env))]
      (with-connection [db db]
        (case command
          "companies" (wikipedia/update-wikipedia-urls db)
          "languages" (languages db args)
          "edits" (apply edits/-main args)
          "views" (apply views/-main args))))))
