(ns antistock.cli.prices
  (:gen-class)
  (:require [antistock.config.core :refer [config]]
            [antistock.db :as db]
            [antistock.db.quotes :as quotes]
            [antistock.db.system :refer [with-db]]
            [antistock.util :refer [remove-nil]]
            [antistock.yahoo.finance :as finance]
            [clojure.string :refer [join]]
            [clojure.tools.logging :refer [info]]
            [commandline.core :refer [print-help with-commandline]]
            [environ.core :refer [env]]
            [datumbazo.core :refer [with-connection]]))

(defn -main [& args]
  (with-commandline [[opts args] args]
    [[h help "Print this help."]]
    (when (:help opts)
      (print-help "prices [OPTION...]")
      (System/exit 0))
    (with-db [db (:db (config env))]
      (with-connection [db db]
        (doseq [price (finance/current (quotes/quotes db {:order-by :symbol}))]
          (if-let [quote (quotes/quote-by-symbol db (:symbol price))]
            (quotes/update-quote
             db (-> (dissoc price :id :symbol)
                    (merge quote )
                    (remove-nil))))
          (info (join "\t" (map price [:symbol :ask :ask-size
                                       :bid :bid-size]))))))))

(comment (-main []))
