(ns antistock.order
  (:require [clojure.string :refer [upper-case]]))

(defrecord Order [symbol side amount price])

(defn buy-order
  "Make a order to buy `amount` shares at `price` of `symbol`."
  [symbol amount price]
  (->Order (upper-case symbol) :buy amount price))

(defn sell-order
  "Make a order to sell `amount` shares at `price` of `symbol`."
  [symbol amount price]
  (->Order (upper-case symbol) :sell amount price))
