(defproject antistock/cli "0.1.21"
  :description "Antistock Command Line Interface"
  :url "https://bitbucket.org/antistock/cli"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[antistock/config "0.1.23"]
                 [antistock/core "0.2.22"]
                 [antistock/db "0.2.46"]
                 [ch.qos.logback/logback-classic "1.1.7" :exclusions [org.slf4j/slf4j-api]]
                 [clj-http "3.0.1"]
                 [enlive "1.1.6"]
                 [geonames "0.6.7"]
                 [hdfs-clj "0.1.16"]
                 [org.apache.hadoop/hadoop-core "1.2.1" :exclusions
                  [commons-cli
                   commons-httpclient
                   org.codehaus.jackson/jackson-core-asl]]
                 [org.clojure/clojure "1.8.0"]
                 [org.slf4j/jcl-over-slf4j "1.7.21"]
                 [org.slf4j/jul-to-slf4j "1.7.21"]
                 [org.slf4j/log4j-over-slf4j "1.7.21"]]
  :plugins [[lein-environ "1.0.2"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :main ^{:skip-aot true} antistock.cli.main
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :source-paths ["dev" "src"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot :all :main antistock.cli.main}}
  :uberjar-name "antistock-cli.jar")
