(ns antistock.cli.historical
  (:gen-class)
  (:require [antistock.config.core :refer [config]]
            [antistock.db.prices :as prices]
            [antistock.db.quotes :as quotes]
            [antistock.db.system :refer [with-db]]
            [clj-time.core :refer [days minus now]]
            [clojure.tools.logging :refer [infof]]
            [commandline.core :refer [print-help with-commandline]]
            [datumbazo.core :refer [with-connection]]
            [environ.core :refer [env]]))

(defn run [config & [opts]]
  (with-db [db (:db config)]
    (with-connection [db db]
      (let [start (or (:start opts) (minus (now) (days 1)))
            end (or (:end opts) (now))
            quotes (quotes/quotes db {:order-by :symbol})]
        (infof "Loading historical prices for %s quotes." (count quotes))
        (infof "Time range: %s - %s" start end)
        (prices/load-prices-for-quotes
         db quotes :start start :end end)))))

(defn -main [& args]
  (with-commandline [[opts args] args]
    [[e end "The end time." :time]
     [h help "Print this help."]
     [s start "The start time." :time]]
    (when (:help opts)
      (print-help "historical [OPTION...]")
      (System/exit 0))
    (run (config env) opts)))
