(ns antistock.cli.main
  (:require [antistock.cli.events :as events]
            [antistock.cli.features :as features]
            [antistock.cli.historical :as historical]
            [antistock.cli.nasdaq :as nasdaq]
            [antistock.cli.prices :as prices]
            [antistock.cli.wikipedia :as wikipedia]
            [antistock.db.fixtures :as fixtures]
            [antistock.util :refer [log-banner]])
  (:gen-class))

(defn print-usage
  "Print help about the available commands."
  []
  (println "Usage: antistock COMMAND\n")
  (println "Available commands:\n")
  (printf "  %-10s - %s\n" "features"
          "Export machine learning features.")
  (printf "  %-10s - %s\n" "fixtures"
          "Manage the database fixtures.")
  (printf "  %-10s - %s\n" "historical"
          "Load historical prices for all stocks from Yahoo Finance.")
  (printf "  %-10s - %s\n" "nasdaq"
          "Import the stock quotes and companies from NASDAQ.")
  (printf "  %-10s - %s\n" "wikipedia"
          "Update the Antistock database from Wikipedia.")
  (println))

(defn -main [& args]
  (let [[command & args] args]
    (log-banner)
    (case command
      "events" (apply events/-main args)
      "features" (apply features/-main args)
      "fixtures" (apply fixtures/-main args)
      "historical" (apply historical/-main args)
      "nasdaq" (apply nasdaq/-main args)
      "prices" (apply prices/-main args)
      "wikipedia" (apply wikipedia/-main args)
      (print-usage))))
