(ns antistock.net.udp
  (:import [java.net DatagramPacket DatagramSocket InetAddress]))

(defn make-socket
  ([] (DatagramSocket.))
  ([port] (DatagramSocket. port)))

(defn send-data [socket host port data]
  (let [address (InetAddress/getByName host)
        packet (DatagramPacket. (.getBytes data) (.length data) address port)]
    (.send socket packet)))

(defn receive-data [receive-socket]
  (let [receive-data (byte-array 1024),
        receive-packet (new DatagramPacket receive-data 1024)]
    (.receive receive-socket receive-packet)
    (String. (.getData receive-packet) 0 (.getLength receive-packet))))
