(ns antistock.cli.events
  (:gen-class)
  (:require [antistock.config.core :refer [config]]
            [antistock.db :as db]
            [antistock.db.events :as events]
            [antistock.db.system :refer [with-db]]
            [clj-time.core :refer [now minus years days]]
            [commandline.core :refer [print-help with-commandline]]
            [environ.core :refer [env]]))

(defn profile [db money & {:keys [start end quotes]}]
  (doseq [event (events/price-before-changed
                 db money :start start :end end :quotes quotes)]
    (prn event)))

(defn -main [& args]
  (with-commandline [args args]
    [[h help "Print this help."]
     [s start "Start with prices at START (default: now - 1 year)." :time]
     [e end "End with prices at END (default: now)." :end]
     [m money "Change of price (default: -5$)." :float]]
    (when help (help))
    (with-db [db (:db (config env))]
      (profile db (or money -5.0) :quotes args :start start :end end))))
