(defproject antistock/cli "0.1.14"
  :description "Antistock Command Line Interface"
  :url "https://bitbucket.org/antistock/cli"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[antistock/config "0.1.14"]
                 [antistock/core "0.2.18"]
                 [antistock/db "0.2.24"]
                 [clj-http "2.1.0"]
                 [ch.qos.logback/logback-classic "1.1.6"]
                 [enlive "1.1.6"]
                 [geonames "0.6.7"]
                 [hdfs-clj "0.1.15"]
                 [org.apache.hadoop/hadoop-core "1.2.1"]
                 [org.clojure/clojure "1.8.0"]]
  :plugins [[lein-environ "1.0.2"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :main ^{:skip-aot true} antistock.cli.main
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :source-paths ["dev" "src"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot :all :main antistock.cli.main}}
  :uberjar-name "antistock-cli.jar")
