(ns antistock.api.client
  (:require [geo.transit :as geo]
            #?(:cljs [routes.core])
            #?(:clj [request.core :refer [defroutes]]
               :cljs [request.core :refer-macros [defroutes]])))
(def server
  {:scheme :https
   :server-name "api.antistock.net"})

(def transit-opts
  "The Transit read and write options."
  #?(:clj
     {:handlers
      {:encode {:handlers geo/write-handlers}
       :decode {:handlers geo/read-handlers}}}
     :cljs
     {:encoding-opts {:handlers geo/write-handlers}
      :decoding-opts {:handlers geo/read-handlers}}))

(def transit-format
  "The default Transit format."
  #?(:clj "application/transit+msgpack"
     :cljs "application/transit+json"))

(defroutes routes
  ["/" :root]
  ["/continents" :continents]
  ["/continents/:id" :continent]
  ["/countries" :countries]
  ["/countries/:id" :country]
  ["/companies" :companies]
  ["/companies/:id" :company]
  ["/twitter/statuses" :twitter-statuses]
  ["/twitter/users" :twitter-users]
  ["/quotes" :quotes]
  ["/quotes/:id" :quote]
  {:accept transit-format
   :content-type transit-format
   :transit-opts transit-opts})
