(ns antistock.api.client
  (:require [request.core :refer [               ]])
         (:require-macros [request.core :refer [defroutes]]))

(defroutes routes
  [;; GET /continents
   {:path-params []
    :path-parts ["" "continents"]
    :path "/continents"
    :method :get
    :path-re #"/continents"
    :route-name :continents}

   ;; GET /continents/:id
   {:path-params [:id]
    :path-parts ["" "continents" :id]
    :path "/continents/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/continents/([^/]+)"
    :route-name :continent}

   ;; GET /countries
   {:path-params []
    :path-parts ["" "countries"]
    :path "/countries"
    :method :get
    :path-re #"/countries"
    :route-name :countries}

   ;; GET /countries/:id
   {:path-params [:id]
    :path-parts ["" "countries" :id]
    :path "/countries/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/countries/([^/]+)"
    :route-name :country}

   ;; GET /companies
   {:path-params []
    :path-parts ["" "companies"]
    :path "/companies"
    :method :get
    :path-re #"/companies"
    :route-name :companies}

   ;; GET /companies/:id
   {:path-params [:id]
    :path-parts ["" "companies" :id]
    :path "/companies/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/companies/([^/]+)"
    :route-name :company}

   ;; GET /twitter/statuses
   {:path-params []
    :path-parts ["" "twitter" "statuses"]
    :path "/twitter/statuses"
    :method :get
    :path-re #"/twitter/statuses"
    :route-name :twitter-statuses}

   ;; GET /twitter/users
   {:path-params []
    :path-parts ["" "twitter" "users"]
    :path "/twitter/users"
    :method :get
    :path-re #"/twitter/users"
    :route-name :twitter-users}

   ;; GET /quotes
   {:path-params []
    :path-parts ["" "quotes"]
    :path "/quotes"
    :method :get
    :path-re #"/quotes"
    :route-name :quotes}

   ;; GET /quotes/:id
   {:path-params [:id]
    :path-parts ["" "quotes" :id]
    :path "/quotes/:id"
    :path-constraints {:id "([^/]+)"}
    :method :get
    :path-re #"/quotes/([^/]+)"
    :route-name :quote}]

  :scheme :http
  :server-name "antistock-api.herokuapp.com"
  :server-port 80)

;;;;;;;;;;;; This file autogenerated from src/antistock/api/client.cljx
