(defproject antistock/accounts "0.1.0"
  :description "Antistock ACCOUNTS"
  :url "https://bitbucket.org/antistock/accounts"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.5.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[antistock/config "0.1.21"]
                 [antistock/core "0.2.23" :exclusions [clj-http]]
                 [antistock/db "0.2.45" :exclusions [clj-http]]
                 [clj-webdriver "0.7.2"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [org.clojure/clojure "1.8.0"]
                 [org.seleniumhq.selenium/selenium-server "2.47.1"]
                 [org.seleniumhq.selenium/selenium-java "2.47.0"]
                 [org.seleniumhq.selenium/selenium-remote-driver "2.47.1"]
                 [com.codeborne/phantomjsdriver "1.2.1"
                  :exclusion [org.seleniumhq.selenium/selenium-java
                              org.seleniumhq.selenium/selenium-server
                              org.seleniumhq.selenium/selenium-remote-driver]]
                 [faker "0.2.2"]
                 [crypto-random "1.2.0"]]
  :plugins [[lein-environ "1.0.2"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:exclude-linters [:constant-test]}
  :main ^{:skip-aot true} antistock.accounts.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.1"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :main ^{:skip-aot true} antistock.accounts.main
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main antistock.accounts.main}}
  :uberjar-name "antistock-accounts.jar")
