(ns antistock.accounts.webdriver
  (:require [clj-webdriver.core :as core]
            [clj-webdriver.driver :as driver]
            [clojure.tools.logging :as log]
            [com.stuartsierra.component :as component])
  (:import clj_webdriver.driver.Driver))

(extend-type Driver
  component/Lifecycle
  (start [webdriver]
    (let [webdriver (core/new-driver {:browser (:browser webdriver)})]
      (log/info "Web driver started.")
      webdriver))
  (stop [webdriver]
    (core/quit webdriver)
    (log/info "Web driver stopped.")
    webdriver))

(defn new-webdriver
  "Return a new web driver using `browser`."
  [& [config]]
  (driver/map->Driver config))
