(ns antistock.accounts.system
  (:require [antistock.accounts.webdriver :refer [new-webdriver]]
            [antistock.system :refer [with-component]]
            [antistock.db.system :refer [new-db]]
            [com.stuartsierra.component :as component]))

(defn new-system
  "Return a new API system."
  [config]
  (let [{:keys [db webdriver]} config]
    (component/system-map
     :config config
     :db (new-db db)
     :webdriver (new-webdriver webdriver))))

(defmacro with-system
  [[system-sym config] & body]
  `(with-component [~system-sym (new-system ~config)]
     ~@body))
