(ns antistock.accounts.anonbox
  (:require [clj-webdriver.taxi :as taxi]
            [clojure.string :as str]
            [schema.core :as s])
  (:import clj_webdriver.driver.Driver))

(def anonbox-url
  "The anonbox URL."
  "https://anonbox.net")

(s/defschema Account
  "The schema of an anonbox account."
  {:email s/Str
   :mailbox-url s/Str})

(defn- create-mailbox
  "Go to the anonbox website and click on the generate mailbox link."
  [webdriver]
  (taxi/to webdriver anonbox-url)
  (taxi/click webdriver "div#header div.action a"))

(defn- parse-mailbox
  "Parse the account information from the mailbox page."
  [webdriver]
  (let [[email mailbox-url]
        (taxi/find-elements webdriver {:css "div#content dl dd p"})]
    {:email (taxi/text email)
     :mailbox-url (taxi/text mailbox-url)}))

(s/defn create-account
  "Create a new anonbox account."
  [webdriver :- Driver]
  (create-mailbox webdriver)
  (parse-mailbox webdriver))

(s/defn to-mailbox
  "Go to the mailbox of `account`."
  [webdriver :- Driver account :- Account]
  (taxi/to webdriver (:mailbox-url account)))

(s/defn read-mailbox
  "Parse the mailbox of `account`."
  [webdriver :- Driver account :- Account]
  (to-mailbox webdriver account)
  (let [content (taxi/text webdriver "body pre")]
    (when-not (str/blank? content)
      content)))

