(ns leiningen.new.angular
  (:use [leiningen.new.templates :only [renderer name-to-path sanitize-ns ->files]]
        [leinjacker.utils :only [lein-generation]]))

(def render (renderer "angular"))

(defn angular
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (println "Generating a new app with Clojure, Bootstrap and AngularJS...")
    (->files data ["project.clj" (render "project.clj" data)]

;; clojure backend
["src/{{sanitized}}/repl.clj" (render "repl.clj" data)]
["src/{{sanitized}}/handler.clj" (render "handler.clj" data)]
["src/{{sanitized}}/routes/api.clj" (render "api.clj" data)]

;; gitignore
[".gitignore" (render ".gitignore")]

;; clojure tests
["test/{{sanitized}}/test/handler.clj" (render "test_handler.clj" data)]

;; app - angular initial setup
["app/views/main.html" (render "main.html")]

["app/css/bootstrap.min.css" (render "bootstrap.min.css")]
["app/css/bootstrap.min.css" (render "bootstrap.theme.min.css")]

["app/js/modernizr.min.js" (render "modernizr.min.js")]

;; npm dependencies
["package.json" (render "package.json" data)]

;; readme
["README.md" (render "README.md" data)]
)
    (println "")
    (println "|--- Enjoy your new project! ------------------------------------------------|")
    (println "|                                                                            |")
    (println "| Be sure to look at the README file and set up the rest of the dependencies |")
    (println "|                                                                            |")
    (println "| Or, if node, compass and grunt are already installed:                      |")
    (println "| $ npm install && bower install && grunt server                             |")
    (println "|                                                                            |")
    (println "|----------------------------------------------------------------------------|")
    (println "")))
