/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.attrib.AttAnnotationDefault;
import com.android.dx.cf.attrib.AttCode;
import com.android.dx.cf.attrib.AttConstantValue;
import com.android.dx.cf.attrib.AttDeprecated;
import com.android.dx.cf.attrib.AttEnclosingMethod;
import com.android.dx.cf.attrib.AttExceptions;
import com.android.dx.cf.attrib.AttInnerClasses;
import com.android.dx.cf.attrib.AttLineNumberTable;
import com.android.dx.cf.attrib.AttLocalVariableTable;
import com.android.dx.cf.attrib.AttLocalVariableTypeTable;
import com.android.dx.cf.attrib.AttRuntimeInvisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeInvisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttSignature;
import com.android.dx.cf.attrib.AttSourceFile;
import com.android.dx.cf.attrib.AttSynthetic;
import com.android.dx.cf.attrib.InnerClassList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.LineNumberList;
import com.android.dx.cf.code.LocalVariableList;
import com.android.dx.cf.direct.AnnotationParser;
import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.AttributeListParser;
import com.android.dx.cf.direct.CodeObserver;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.rop.annotation.AnnotationVisibility;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.TypedConstant;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import java.io.IOException;

public class StdAttributeFactory
extends AttributeFactory {
    public static final StdAttributeFactory THE_ONE = new StdAttributeFactory();

    protected Attribute parse0(DirectClassFile cf, int context, String name2, int offset, int length, ParseObserver observer) {
        switch (context) {
            case 0: {
                if (name2 == "Deprecated") {
                    return this.deprecated(cf, offset, length, observer);
                }
                if (name2 == "EnclosingMethod") {
                    return this.enclosingMethod(cf, offset, length, observer);
                }
                if (name2 == "InnerClasses") {
                    return this.innerClasses(cf, offset, length, observer);
                }
                if (name2 == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "Synthetic") {
                    return this.synthetic(cf, offset, length, observer);
                }
                if (name2 == "Signature") {
                    return this.signature(cf, offset, length, observer);
                }
                if (name2 != "SourceFile") break;
                return this.sourceFile(cf, offset, length, observer);
            }
            case 1: {
                if (name2 == "ConstantValue") {
                    return this.constantValue(cf, offset, length, observer);
                }
                if (name2 == "Deprecated") {
                    return this.deprecated(cf, offset, length, observer);
                }
                if (name2 == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "Signature") {
                    return this.signature(cf, offset, length, observer);
                }
                if (name2 != "Synthetic") break;
                return this.synthetic(cf, offset, length, observer);
            }
            case 2: {
                if (name2 == "AnnotationDefault") {
                    return this.annotationDefault(cf, offset, length, observer);
                }
                if (name2 == "Code") {
                    return this.code(cf, offset, length, observer);
                }
                if (name2 == "Deprecated") {
                    return this.deprecated(cf, offset, length, observer);
                }
                if (name2 == "Exceptions") {
                    return this.exceptions(cf, offset, length, observer);
                }
                if (name2 == "RuntimeInvisibleAnnotations") {
                    return this.runtimeInvisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "RuntimeVisibleAnnotations") {
                    return this.runtimeVisibleAnnotations(cf, offset, length, observer);
                }
                if (name2 == "RuntimeInvisibleParameterAnnotations") {
                    return this.runtimeInvisibleParameterAnnotations(cf, offset, length, observer);
                }
                if (name2 == "RuntimeVisibleParameterAnnotations") {
                    return this.runtimeVisibleParameterAnnotations(cf, offset, length, observer);
                }
                if (name2 == "Signature") {
                    return this.signature(cf, offset, length, observer);
                }
                if (name2 != "Synthetic") break;
                return this.synthetic(cf, offset, length, observer);
            }
            case 3: {
                if (name2 == "LineNumberTable") {
                    return this.lineNumberTable(cf, offset, length, observer);
                }
                if (name2 == "LocalVariableTable") {
                    return this.localVariableTable(cf, offset, length, observer);
                }
                if (name2 != "LocalVariableTypeTable") break;
                return this.localVariableTypeTable(cf, offset, length, observer);
            }
        }
        return super.parse0(cf, context, name2, offset, length, observer);
    }

    private Attribute annotationDefault(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser ap = new AnnotationParser(cf, offset, length, observer);
        Constant cst = ap.parseValueAttribute();
        return new AttAnnotationDefault(cst, length);
    }

    private Attribute code(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        int exceptionTableLength;
        ByteCatchList catches;
        if (length < 12) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int maxStack = bytes2.getUnsignedShort(offset);
        int maxLocals = bytes2.getUnsignedShort(offset + 2);
        int codeLength = bytes2.getInt(offset + 4);
        int origOffset = offset;
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "max_stack: " + Hex.u2(maxStack));
            observer.parsed(bytes2, offset + 2, 2, "max_locals: " + Hex.u2(maxLocals));
            observer.parsed(bytes2, offset + 4, 4, "code_length: " + Hex.u4(codeLength));
        }
        offset += 8;
        if ((length -= 8) < codeLength + 4) {
            return StdAttributeFactory.throwTruncated();
        }
        int codeOffset = offset;
        offset += codeLength;
        length -= codeLength;
        BytecodeArray code = new BytecodeArray(bytes2.slice(codeOffset, codeOffset + codeLength), pool);
        if (observer != null) {
            code.forEach(new CodeObserver(code.getBytes(), observer));
        }
        ByteCatchList byteCatchList = catches = (exceptionTableLength = bytes2.getUnsignedShort(offset)) == 0 ? ByteCatchList.EMPTY : new ByteCatchList(exceptionTableLength);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "exception_table_length: " + Hex.u2(exceptionTableLength));
        }
        offset += 2;
        if ((length -= 2) < exceptionTableLength * 8 + 2) {
            return StdAttributeFactory.throwTruncated();
        }
        for (int i = 0; i < exceptionTableLength; ++i) {
            if (observer != null) {
                observer.changeIndent(1);
            }
            int startPc = bytes2.getUnsignedShort(offset);
            int endPc = bytes2.getUnsignedShort(offset + 2);
            int handlerPc = bytes2.getUnsignedShort(offset + 4);
            int catchTypeIdx = bytes2.getUnsignedShort(offset + 6);
            CstType catchType = (CstType)pool.get0Ok(catchTypeIdx);
            catches.set(i, startPc, endPc, handlerPc, catchType);
            if (observer != null) {
                observer.parsed(bytes2, offset, 8, Hex.u2(startPc) + ".." + Hex.u2(endPc) + " -> " + Hex.u2(handlerPc) + " " + (catchType == null ? "<any>" : catchType.toHuman()));
            }
            offset += 8;
            length -= 8;
            if (observer == null) continue;
            observer.changeIndent(-1);
        }
        catches.setImmutable();
        AttributeListParser parser = new AttributeListParser(cf, 3, offset, this);
        parser.setObserver(observer);
        StdAttributeList attributes = parser.getList();
        attributes.setImmutable();
        int attributeByteCount = parser.getEndOffset() - offset;
        if (attributeByteCount != length) {
            return StdAttributeFactory.throwBadLength(attributeByteCount + (offset - origOffset));
        }
        return new AttCode(maxStack, maxLocals, code, catches, attributes);
    }

    private Attribute constantValue(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 2) {
            return StdAttributeFactory.throwBadLength(2);
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int idx = bytes2.getUnsignedShort(offset);
        TypedConstant cst = (TypedConstant)pool.get(idx);
        AttConstantValue result = new AttConstantValue(cst);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "value: " + cst);
        }
        return result;
    }

    private Attribute deprecated(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 0) {
            return StdAttributeFactory.throwBadLength(0);
        }
        return new AttDeprecated();
    }

    private Attribute enclosingMethod(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 4) {
            StdAttributeFactory.throwBadLength(4);
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int idx = bytes2.getUnsignedShort(offset);
        CstType type2 = (CstType)pool.get(idx);
        idx = bytes2.getUnsignedShort(offset + 2);
        CstNat method = (CstNat)pool.get0Ok(idx);
        AttEnclosingMethod result = new AttEnclosingMethod(type2, method);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "class: " + type2);
            observer.parsed(bytes2, offset + 2, 2, "method: " + DirectClassFile.stringOrNone(method));
        }
        return result;
    }

    private Attribute exceptions(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        int count2 = bytes2.getUnsignedShort(offset);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "number_of_exceptions: " + Hex.u2(count2));
        }
        offset += 2;
        if ((length -= 2) != count2 * 2) {
            StdAttributeFactory.throwBadLength(count2 * 2 + 2);
        }
        TypeList list = cf.makeTypeList(offset, count2);
        return new AttExceptions(list);
    }

    private Attribute innerClasses(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int count2 = bytes2.getUnsignedShort(offset);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "number_of_classes: " + Hex.u2(count2));
        }
        offset += 2;
        if ((length -= 2) != count2 * 8) {
            StdAttributeFactory.throwBadLength(count2 * 8 + 2);
        }
        InnerClassList list = new InnerClassList(count2);
        for (int i = 0; i < count2; ++i) {
            int innerClassIdx = bytes2.getUnsignedShort(offset);
            int outerClassIdx = bytes2.getUnsignedShort(offset + 2);
            int nameIdx = bytes2.getUnsignedShort(offset + 4);
            int accessFlags = bytes2.getUnsignedShort(offset + 6);
            CstType innerClass = (CstType)pool.get(innerClassIdx);
            CstType outerClass = (CstType)pool.get0Ok(outerClassIdx);
            CstString name2 = (CstString)pool.get0Ok(nameIdx);
            list.set(i, innerClass, outerClass, name2, accessFlags);
            if (observer != null) {
                observer.parsed(bytes2, offset, 2, "inner_class: " + DirectClassFile.stringOrNone(innerClass));
                observer.parsed(bytes2, offset + 2, 2, "  outer_class: " + DirectClassFile.stringOrNone(outerClass));
                observer.parsed(bytes2, offset + 4, 2, "  name: " + DirectClassFile.stringOrNone(name2));
                observer.parsed(bytes2, offset + 6, 2, "  access_flags: " + AccessFlags.innerClassString(accessFlags));
            }
            offset += 8;
        }
        list.setImmutable();
        return new AttInnerClasses(list);
    }

    private Attribute lineNumberTable(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        int count2 = bytes2.getUnsignedShort(offset);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "line_number_table_length: " + Hex.u2(count2));
        }
        offset += 2;
        if ((length -= 2) != count2 * 4) {
            StdAttributeFactory.throwBadLength(count2 * 4 + 2);
        }
        LineNumberList list = new LineNumberList(count2);
        for (int i = 0; i < count2; ++i) {
            int startPc = bytes2.getUnsignedShort(offset);
            int lineNumber = bytes2.getUnsignedShort(offset + 2);
            list.set(i, startPc, lineNumber);
            if (observer != null) {
                observer.parsed(bytes2, offset, 4, Hex.u2(startPc) + " " + lineNumber);
            }
            offset += 4;
        }
        list.setImmutable();
        return new AttLineNumberTable(list);
    }

    private Attribute localVariableTable(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        int count2 = bytes2.getUnsignedShort(offset);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "local_variable_table_length: " + Hex.u2(count2));
        }
        LocalVariableList list = this.parseLocalVariables(bytes2.slice(offset + 2, offset + length), cf.getConstantPool(), observer, count2, false);
        return new AttLocalVariableTable(list);
    }

    private Attribute localVariableTypeTable(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            return StdAttributeFactory.throwSeverelyTruncated();
        }
        ByteArray bytes2 = cf.getBytes();
        int count2 = bytes2.getUnsignedShort(offset);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "local_variable_type_table_length: " + Hex.u2(count2));
        }
        LocalVariableList list = this.parseLocalVariables(bytes2.slice(offset + 2, offset + length), cf.getConstantPool(), observer, count2, true);
        return new AttLocalVariableTypeTable(list);
    }

    private LocalVariableList parseLocalVariables(ByteArray bytes2, ConstantPool pool, ParseObserver observer, int count2, boolean typeTable) {
        if (bytes2.size() != count2 * 10) {
            StdAttributeFactory.throwBadLength(count2 * 10 + 2);
        }
        ByteArray.MyDataInputStream in = bytes2.makeDataInputStream();
        LocalVariableList list = new LocalVariableList(count2);
        try {
            for (int i = 0; i < count2; ++i) {
                int startPc = in.readUnsignedShort();
                int length = in.readUnsignedShort();
                int nameIdx = in.readUnsignedShort();
                int typeIdx = in.readUnsignedShort();
                int index2 = in.readUnsignedShort();
                CstString name2 = (CstString)pool.get(nameIdx);
                CstString type2 = (CstString)pool.get(typeIdx);
                CstString descriptor2 = null;
                CstString signature = null;
                if (typeTable) {
                    signature = type2;
                } else {
                    descriptor2 = type2;
                }
                list.set(i, startPc, length, name2, descriptor2, signature, index2);
                if (observer == null) continue;
                observer.parsed(bytes2, i * 10, 10, Hex.u2(startPc) + ".." + Hex.u2(startPc + length) + " " + Hex.u2(index2) + " " + name2.toHuman() + " " + type2.toHuman());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("shouldn't happen", ex);
        }
        list.setImmutable();
        return list;
    }

    private Attribute runtimeInvisibleAnnotations(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser ap = new AnnotationParser(cf, offset, length, observer);
        Annotations annotations = ap.parseAnnotationAttribute(AnnotationVisibility.BUILD);
        return new AttRuntimeInvisibleAnnotations(annotations, length);
    }

    private Attribute runtimeVisibleAnnotations(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser ap = new AnnotationParser(cf, offset, length, observer);
        Annotations annotations = ap.parseAnnotationAttribute(AnnotationVisibility.RUNTIME);
        return new AttRuntimeVisibleAnnotations(annotations, length);
    }

    private Attribute runtimeInvisibleParameterAnnotations(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser ap = new AnnotationParser(cf, offset, length, observer);
        AnnotationsList list = ap.parseParameterAttribute(AnnotationVisibility.BUILD);
        return new AttRuntimeInvisibleParameterAnnotations(list, length);
    }

    private Attribute runtimeVisibleParameterAnnotations(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length < 2) {
            StdAttributeFactory.throwSeverelyTruncated();
        }
        AnnotationParser ap = new AnnotationParser(cf, offset, length, observer);
        AnnotationsList list = ap.parseParameterAttribute(AnnotationVisibility.RUNTIME);
        return new AttRuntimeVisibleParameterAnnotations(list, length);
    }

    private Attribute signature(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 2) {
            StdAttributeFactory.throwBadLength(2);
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int idx = bytes2.getUnsignedShort(offset);
        CstString cst = (CstString)pool.get(idx);
        AttSignature result = new AttSignature(cst);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "signature: " + cst);
        }
        return result;
    }

    private Attribute sourceFile(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 2) {
            StdAttributeFactory.throwBadLength(2);
        }
        ByteArray bytes2 = cf.getBytes();
        ConstantPool pool = cf.getConstantPool();
        int idx = bytes2.getUnsignedShort(offset);
        CstString cst = (CstString)pool.get(idx);
        AttSourceFile result = new AttSourceFile(cst);
        if (observer != null) {
            observer.parsed(bytes2, offset, 2, "source: " + cst);
        }
        return result;
    }

    private Attribute synthetic(DirectClassFile cf, int offset, int length, ParseObserver observer) {
        if (length != 0) {
            return StdAttributeFactory.throwBadLength(0);
        }
        return new AttSynthetic();
    }

    private static Attribute throwSeverelyTruncated() {
        throw new ParseException("severely truncated attribute");
    }

    private static Attribute throwTruncated() {
        throw new ParseException("truncated attribute");
    }

    private static Attribute throwBadLength(int expected) {
        throw new ParseException("bad attribute length; expected length " + Hex.u4(expected));
    }
}

