(ns leiningen.ring.uberjar
  (:use [leiningen.ring.util :only (ensure-handler-set!)]
        [leiningen.ring.server :only (add-server-dep)])
  (:require [leiningen.ring.jar :as jar]
            [leiningen.clean :as clean]
            leiningen.uberjar))

(defn- assoc-profile [project profile-name key value]
  (let [profile (get-in project [:profiles profile-name])]
    (assoc-in project [:profiles profile-name]
              (cond
               (vector? profile) (conj profile {key value})
               (map? profile)    (assoc profile key value)
               (nil? profile)    {key value}))))

(defn- no-uberjar-clean [project]
  "Modifies the uberjar profile so that no auto-clean is performed
  when leiningen takes control, thus avoiding the autogenerated main files
  from being wiped."
  (vary-meta project assoc-profile :uberjar :auto-clean false))

(defn uberjar
  "Create an executable $PROJECT-$VERSION.jar file with dependencies."
  [project]
  (ensure-handler-set! project)
  (when (:auto-clean project true)
    (clean/clean project))
  (let [project (-> project add-server-dep jar/add-main-class no-uberjar-clean)]
    (jar/compile-main project)
    (leiningen.uberjar/uberjar project)))
