/*
 * Decompiled with CFR 0.152.
 */
package br.unb.biologiaanimal.edf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

class EDFWriter {
    private File file;
    private String path;
    private BufferedWriter typewriter;

    public EDFWriter() throws IOException {
        this.construct();
    }

    public EDFWriter(String filePath) throws IOException {
        if (filePath == null) {
            this.construct();
        } else {
            this.path = filePath;
            this.file = new File(this.path);
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.typewriter = new BufferedWriter(new FileWriter(this.file.getAbsoluteFile()));
        }
    }

    private void construct() throws IOException {
        this.path = null;
        this.file = null;
        this.typewriter = new BufferedWriter(new PrintWriter(System.out));
    }

    public void write(String data) throws IOException {
        this.typewriter.write(data);
    }

    public void close() throws IOException {
        this.typewriter.close();
    }

    public static String sayHi() {
        return "Hello from EDF Writer!";
    }
}

