/*
 * Decompiled with CFR 0.152.
 */
package br.unb.biologiaanimal.edf;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EDFUtil {
    public static String[] separateString(String inlet, int numChops) {
        String[] outlet = new String[numChops];
        int step = inlet.length() / numChops;
        for (int i = 0; i < numChops; ++i) {
            outlet[i] = inlet.substring(i * step, (i + 1) * step);
        }
        return outlet;
    }

    public static String joinStrings(String[] inlet, String sep) {
        String outlet = inlet[0];
        for (int i = 1; i < inlet.length; ++i) {
            outlet = outlet + sep + inlet[i];
        }
        return outlet;
    }

    public static byte[] insert(byte[] box, byte it) {
        byte[] newBox;
        if (box == null) {
            newBox = new byte[1];
        } else {
            newBox = new byte[box.length + 1];
            for (int i = 0; i < box.length; ++i) {
                newBox[i] = box[i];
            }
        }
        newBox[newBox.length - 1] = it;
        return newBox;
    }

    public static byte[] insert(byte[] inlet, byte[] toAdd) {
        byte[] outlet;
        if (inlet == null) {
            outlet = toAdd;
        } else {
            outlet = new byte[inlet.length + toAdd.length];
            int j = 0;
            int i = 0;
            while (i < inlet.length) {
                outlet[j] = inlet[i];
                ++i;
                ++j;
            }
            i = 0;
            while (i < toAdd.length) {
                outlet[j] = toAdd[i];
                ++i;
                ++j;
            }
        }
        return outlet;
    }

    public static short[] translate(byte[] inlet) {
        ByteBuffer buffer = ByteBuffer.wrap(inlet);
        int limit = inlet.length / 2;
        short[] outlet = new short[limit];
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < limit; ++i) {
            outlet[i] = buffer.getShort();
        }
        return outlet;
    }

    public static double convert(double x, double dmax, double dmin, double pmax, double pmin) {
        return x * (dmax - dmin) / (pmax - pmin);
    }

    public static double map(double x, double in_min, double in_max, double out_min, double out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }
}

