/*
 * Decompiled with CFR 0.152.
 */
package br.unb.biologiaanimal.edf;

import br.unb.biologiaanimal.edf.EDFConstants;
import br.unb.biologiaanimal.edf.EDFUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;

class EDFReader {
    private String path;
    private String data;
    private HashMap header;
    private HashMap records;
    private int numberSignals;

    public EDFReader(String input) {
        this.path = input;
        try {
            byte[] buffer = new byte[256];
            FileInputStream stream = new FileInputStream(this.path);
            this.readHeader(stream);
            this.readRecords(stream);
        }
        catch (Exception any) {
            System.out.println(any);
        }
    }

    private void readHeader(FileInputStream stream) throws IOException {
        byte[] buffer;
        int limit = EDFConstants.specs.length;
        int i = 0;
        this.header = new HashMap();
        for (i = 0; i < limit; ++i) {
            buffer = new byte[EDFConstants.lenghts[i]];
            String data = EDFConstants.specs[i];
            if (data.equals("label")) break;
            stream.read(buffer);
            this.header.put(EDFConstants.specs[i], new String(buffer));
        }
        this.numberSignals = this.paramToInt("numbersignals");
        while (i < limit) {
            buffer = new byte[EDFConstants.lenghts[i]];
            StringBuffer box = new StringBuffer();
            for (int n = 0; n < this.numberSignals; ++n) {
                stream.read(buffer);
                box.append(new String(buffer));
            }
            this.header.put(EDFConstants.specs[i], box.toString());
            ++i;
        }
    }

    private void readRecords(FileInputStream stream) throws IOException {
        int i;
        this.records = new HashMap();
        int[] numberSamples = this.getNumberSamples();
        int[] sampling = new int[this.numberSignals];
        int duration = this.paramToInt("duration");
        int dataRecords = this.paramToInt("datarecords");
        byte[][] recordList = new byte[this.numberSignals][5];
        String[] labels = this.getLabels();
        byte[] buffer = null;
        for (i = 0; i < this.numberSignals; ++i) {
            sampling[i] = duration * numberSamples[i];
            recordList[i] = null;
        }
        for (int d = 0; d < dataRecords; ++d) {
            for (int i2 = 0; i2 < this.numberSignals; ++i2) {
                duration = 2 * sampling[i2];
                buffer = new byte[duration];
                stream.read(buffer);
                recordList[i2] = recordList[i2] == null ? buffer : EDFUtil.insert(recordList[i2], buffer);
            }
        }
        for (i = 0; i < this.numberSignals; ++i) {
            String label = labels[i].trim();
            this.records.put(label, recordList[i]);
        }
    }

    private int[] getNumberSamples() {
        int[] numberSamples = new int[this.numberSignals];
        String rawSamples = (String)this.header.get("samplesrecord");
        String[] samples = EDFUtil.separateString(rawSamples, this.numberSignals);
        for (int i = 0; i < this.numberSignals; ++i) {
            numberSamples[i] = Integer.parseInt(samples[i].trim());
        }
        return numberSamples;
    }

    private int paramToInt(String param) {
        return Integer.parseInt(((String)this.header.get(param)).trim());
    }

    public String getPath() {
        return this.path;
    }

    public String getData() {
        String outlet = "";
        for (String label : this.getLabels()) {
            byte[] record = this.getRecord(label);
            outlet = outlet + label + ": " + record.length + "\n";
        }
        return outlet;
    }

    public HashMap getHeader() {
        return this.header;
    }

    public HashMap getRecords() {
        return this.records;
    }

    public byte[] getRecord(String label) {
        return (byte[])this.records.get(label);
    }

    public int getAnnotationsChannelIndex() {
        String[] labels = this.getLabels();
        int limit = this.getNumberSignals();
        for (int index = 0; index < limit; ++index) {
            if (!labels[index].equals("EDF Annotations")) continue;
            return index;
        }
        return -1;
    }

    public int getNumberSignals() {
        return this.paramToInt("numbersignals");
    }

    public String[] getLabels() {
        String rawData = (String)this.header.get("label");
        String[] raw = EDFUtil.separateString(rawData, this.numberSignals);
        String[] labels = new String[this.numberSignals];
        for (int i = 0; i < this.numberSignals; ++i) {
            labels[i] = raw[i].trim();
        }
        return labels;
    }

    public double[] getConvertionFactors() {
        double[] dmax = this.getDigitalMaxima();
        double[] dmin = this.getDigitalMinima();
        double[] pmax = this.getPhysicalMaxima();
        double[] pmin = this.getPhysicalMinima();
        double[] outlet = new double[this.numberSignals];
        for (int i = 0; i < this.numberSignals; ++i) {
            outlet[i] = EDFUtil.convert(1.0, dmax[i], dmin[i], pmax[i], pmin[i]);
        }
        return outlet;
    }

    public double[] getDigitalMaxima() {
        return this.getLimits("digitalmaximum");
    }

    public double[] getDigitalMinima() {
        return this.getLimits("digitalminimum");
    }

    public double[] getPhysicalMaxima() {
        return this.getLimits("physicalmaximum");
    }

    public double[] getPhysicalMinima() {
        return this.getLimits("physicalminimum");
    }

    private double[] getLimits(String param) {
        String rawLimits = (String)this.header.get(param);
        String[] stuff = EDFUtil.separateString(rawLimits, this.numberSignals);
        double[] outlet = new double[this.numberSignals];
        for (int i = 0; i < this.numberSignals; ++i) {
            outlet[i] = Double.parseDouble(stuff[i].trim());
        }
        return outlet;
    }

    public String[] getAnnotations() throws NoSuchFieldException {
        int annotationsChannel = this.getAnnotationsChannelIndex();
        if (annotationsChannel < 0) {
            throw new NoSuchFieldException();
        }
        return this.getRawNotes().split("\n");
    }

    private String getRawNotes() {
        byte[] raw = this.getRecord("EDF Annotations");
        String outlet = "";
        boolean inside = false;
        for (int i = 0; i < raw.length; ++i) {
            if (inside) {
                if (raw[i] == 0) {
                    inside = false;
                    outlet = outlet + "\n";
                    continue;
                }
                int it = raw[i];
                boolean fact = it == 20 || it == 21;
                raw[i] = fact ? 32 : it;
                outlet = outlet + (char)raw[i];
                continue;
            }
            if (raw[i] != 43 && raw[i] != 45) continue;
            inside = true;
            outlet = outlet + (char)raw[i];
        }
        return outlet;
    }
}

