/*
 * Decompiled with CFR 0.152.
 */
package br.unb.biologiaanimal.edf;

import br.unb.biologiaanimal.edf.EDFReader;
import br.unb.biologiaanimal.edf.EDFUtil;
import br.unb.biologiaanimal.edf.EDFWriter;
import java.io.IOException;
import java.util.HashMap;

public class EDF {
    private String file;
    private EDFReader reader;

    public EDF(String filePath) {
        this.file = filePath;
        this.reader = new EDFReader(this.file);
    }

    public String getFile() {
        return this.reader.getPath();
    }

    public String getData() {
        String outlet = "";
        String channel = "ECG";
        byte[] record = this.reader.getRecord(channel);
        short[] data = EDFUtil.translate(record);
        double convertionFactor = this.getConvertionFactor(channel);
        for (int i = 0; i < data.length; ++i) {
            double value = (double)data[i] * convertionFactor;
            outlet = outlet + value + "\n";
        }
        return outlet;
    }

    public HashMap getHeader() {
        return this.reader.getHeader();
    }

    public HashMap getRecords() {
        return this.reader.getRecords();
    }

    public String[] getLabels() {
        return this.reader.getLabels();
    }

    public int getSamplingRate() {
        int numberSignals = this.reader.getNumberSignals();
        String raw = (String)this.getHeader().get("samplesrecord");
        String[] samples = EDFUtil.separateString(raw, numberSignals);
        return Integer.parseInt(samples[0].trim());
    }

    public String sayHi() {
        return EDFWriter.sayHi();
    }

    public void write(String what) throws IOException {
        EDFWriter writer = new EDFWriter();
        writer.write(what);
    }

    public void toAscii(String filePath) throws IOException {
        double[] signal;
        int i;
        EDFWriter writer = new EDFWriter(filePath);
        String[] labels = this.reader.getLabels();
        double[][] signals = new double[labels.length][2];
        int limit = 0;
        for (i = 0; i < labels.length; ++i) {
            String label = labels[i];
            signal = this.getSignal(label);
            signals[i] = signal;
            if (limit >= signal.length) continue;
            limit = signal.length;
        }
        for (i = 0; i < limit; ++i) {
            for (int j = 0; j < labels.length; ++j) {
                signal = signals[j];
                double value = signal.length > i ? signal[i] : 0.0;
                writer.write(value + " ");
            }
            writer.write("\n");
        }
        writer.close();
    }

    public void toSingleChannelAscii(String filePath, String channel) throws IOException {
        double[] signal = this.getSignal(channel);
        EDFWriter writer = new EDFWriter(filePath);
        for (int i = 0; i < signal.length; ++i) {
            writer.write(signal[i] + "\n");
        }
        writer.close();
    }

    public void toCsv(String filePath) throws IOException {
        double[] signal;
        int i;
        EDFWriter writer = new EDFWriter(filePath);
        String[] labels = this.reader.getLabels();
        double[][] signals = new double[labels.length][2];
        HashMap header = this.reader.getHeader();
        int limit = 0;
        writer.write("title:" + (String)header.get("recording") + ";");
        writer.write("recorded:" + (String)header.get("startdate") + " " + (String)header.get("starttime") + ";");
        writer.write("sampling:" + Integer.toString(this.getSamplingRate()) + ";");
        writer.write("subject:" + (String)header.get("patient") + ";");
        writer.write("labels:" + EDFUtil.joinStrings(this.getLabels(), "\t") + ";");
        writer.write("chan:" + (String)header.get("numbersignals") + ";");
        writer.write("units:uV\n");
        for (i = 0; i < labels.length; ++i) {
            String label = labels[i];
            signal = this.getSignal(label);
            signals[i] = signal;
            if (limit >= signal.length) continue;
            limit = signal.length;
        }
        for (i = 0; i < limit; ++i) {
            for (int j = 0; j < labels.length; ++j) {
                if (j == this.reader.getAnnotationsChannelIndex()) continue;
                signal = signals[j];
                double value = signal.length > i ? signal[i] : 0.0;
                writer.write((j == 0 ? "" : "; ") + Double.toString(value));
            }
            writer.write("\n");
        }
        writer.close();
    }

    public String[] getAnnotations() throws NoSuchFieldException {
        return this.reader.getAnnotations();
    }

    private int getLabelIndex(String label) {
        String[] labels = this.reader.getLabels();
        int limit = this.reader.getNumberSignals();
        int result = -1;
        for (int i = 0; i < limit && result < 0; ++i) {
            if (!label.equals(labels[i])) continue;
            result = i;
        }
        return result;
    }

    public double getConvertionFactor(String label) {
        return this.reader.getConvertionFactors()[this.getLabelIndex(label)];
    }

    public double[] getSignal(String label) {
        double convertionFactor = this.getConvertionFactor(label);
        short[] raw = EDFUtil.translate(this.reader.getRecord(label));
        int[] data = new int[raw.length];
        double[] signal = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = raw[i] + Short.MAX_VALUE;
            signal[i] = (double)data[i] * convertionFactor;
        }
        return signal;
    }
}

