[![CircleCI](https://circleci.com/gh/AndreaCrotti/dateutils/tree/master.svg?style=svg)](https://circleci.com/gh/AndreaCrotti/dateutils/tree/master)

# dateutils

Helper functions to convert between different types of date/datetime representations.

## Usage

This library has a very simple API, a `convert` function that allows you to convert between different types.

For example:

```clojure
(require '[dateutils.core :as dt])
(dt/convert ::dt/seconds-from-epoch ::dt/ms-from-epoch 1000) ; 1000000
```

The from-type and to-type that can be used are all specced so and the input/output type is checked.
You can convert between any type to any other type in this way, so no need to compose different conversions.

Conversions supported are from any to any in this list of formats:
- ms-since-epoch
- seconds-since-epoch
- date-str
- datetime-str
- days-since-epoch

## License

Copyright © 2020 Andrea Crotti

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
