CREATE TABLE IF NOT EXISTS location_context
(id BIGINT AUTO_INCREMENT,
 op_id BIGINT NOT NULL,
 op_type VARCHAR(10) NOT NULL,
 site_id VARCHAR(256) NOT NULL,
 user_id VARCHAR(256) NOT NULL,
 session_id VARCHAR(50) NOT NULL,
 page VARCHAR(500) NULL,
 event VARCHAR(500) NULL,
 loc_latitude VARCHAR(20) NULL,
 loc_longitude VARCHAR(20) NULL,
 loc_country_code VARCHAR(5) NULL,
 loc_city VARCHAR(100) NULL,
 loc_postal_code CHAR(5) NULL,
 loc_organization VARCHAR(100) NULL,
 created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
 PRIMARY KEY (id),
 FOREIGN KEY (user_id) REFERENCES users(user_id) ON UPDATE CASCADE,
 FOREIGN KEY (session_id) REFERENCES sessions(session_id) ON DELETE CASCADE,
 FOREIGN KEY (site_id) REFERENCES sites(site_id) ON DELETE CASCADE);
