(ns manifold.java8
  (:require
    [manifold.stream
     [core :as s]
     [iterator :as i]]
    [manifold
     [deferred :as d]
     [utils :as utils]])
  (:import
    [java.util.concurrent.atomic
     AtomicReference]))

(let [extensions (delay (eval `(do
                                 (utils/when-class java.util.stream.BaseStream
                                   (extend-protocol s/Sourceable
                                     java.util.stream.BaseStream
                                     (to-source [^java.util.stream.BaseStream stream#]
                                       (#'i/->IteratorSource ;; because it's private
                                         (.iterator stream#)
                                         (AtomicReference. (d/success-deferred true))))))
                                 (utils/when-class java.util.concurrent.CompletableFuture
                                   (extend-protocol d/Deferrable
                                     java.util.concurrent.CompletableFuture
                                     (to-deferred [^java.util.concurrent.CompletableFuture f#]
                                       (let [d# (d/deferred)]
                                         (.handle f#
                                           (reify java.util.function.BiFunction
                                             (apply [_ val# err#]
                                               (if (nil? err#)
                                                 (d/success! d# val#)
                                                 (d/error! d# err#)))))
                                         d#)))))))]
  (defn enable-java8-extensions! []
    @extensions))