(ns allgress.cereus.util
  (:require-macros [cljs.core.async.macros :refer [go]])
  (:require [cljs.core.async :refer [chan put!]]
            [allgress.cereus.core :refer [listen!]]))

(enable-console-print!)
(def polymer-ready (atom false))

(if (and
      (some? (aget js/window "Polymer"))
      (some? (aget js/window "Polymer" "Base"))
      (some? (aget js/window "Polymer" "Base" "importHref")))
  (reset! polymer-ready true)
  (listen! js/window "WebComponentsReady" (fn [e] (reset! polymer-ready true))))

(defn import-polymer
  [url]
  (let [c (chan)]
    (if @polymer-ready
      (.importHref (.-Base js/Polymer) (clj->js url) (fn [e] (put! c true)))
      (add-watch polymer-ready url
                 (fn [_ _ _ _]
                   (remove-watch polymer-ready url)
                   (.importHref (.-Base js/Polymer) (clj->js url) (fn [e] (put! c true))))))
    c))