/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.client.Connection;
import io.nats.client.NUID;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.streaming.AckHandler;
import io.nats.streaming.Message;
import io.nats.streaming.MessageHandler;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.Subscription;
import io.nats.streaming.SubscriptionImpl;
import io.nats.streaming.SubscriptionOptions;
import io.nats.streaming.protobuf.Ack;
import io.nats.streaming.protobuf.CloseRequest;
import io.nats.streaming.protobuf.CloseResponse;
import io.nats.streaming.protobuf.ConnectRequest;
import io.nats.streaming.protobuf.ConnectResponse;
import io.nats.streaming.protobuf.MsgProto;
import io.nats.streaming.protobuf.PubAck;
import io.nats.streaming.protobuf.PubMsg;
import io.nats.streaming.protobuf.SubscriptionRequest;
import io.nats.streaming.protobuf.SubscriptionResponse;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import shaded.nats.com.google.protobuf.ByteString;
import shaded.nats.com.google.protobuf.InvalidProtocolBufferException;

class StreamingConnectionImpl
implements StreamingConnection,
io.nats.client.MessageHandler {
    static final String ERR_MANUAL_ACK = "stan: cannot manually ack in auto-ack mode";
    private final ReadWriteLock mu = new ReentrantReadWriteLock();
    private String clientId;
    private String clusterId;
    String pubPrefix;
    String subRequests;
    String unsubRequests;
    String subCloseRequests;
    String closeRequests;
    String ackSubject;
    private io.nats.client.Subscription ackSubscription;
    io.nats.client.Subscription hbSubscription;
    io.nats.client.MessageHandler hbCallback;
    Map<String, Subscription> subMap;
    Map<String, AckClosure> pubAckMap;
    private BlockingQueue<PubAck> pubAckChan;
    Options opts;
    Connection nc;
    final Timer ackTimer = new Timer("jnats-streaming ack timeout thread", true);
    boolean ncOwned = false;
    ExecutorService exec = Executors.newCachedThreadPool();

    StreamingConnectionImpl() {
    }

    StreamingConnectionImpl(String stanClusterId, String clientId) {
        this(stanClusterId, clientId, null);
    }

    StreamingConnectionImpl(String stanClusterId, String clientId, Options opts) {
        this.clusterId = stanClusterId;
        this.clientId = clientId;
        if (opts == null) {
            this.opts = new Options.Builder().build();
        } else {
            this.opts = opts;
            if (this.opts.getNatsConn() != null) {
                this.setNatsConnection(this.opts.getNatsConn());
            }
        }
    }

    StreamingConnectionImpl connect() throws IOException, InterruptedException {
        boolean exThrown = false;
        Connection nc = this.getNatsConnection();
        if (nc == null) {
            nc = this.createNatsConnection();
            this.setNatsConnection(nc);
            this.ncOwned = true;
        } else if (!nc.isConnected()) {
            throw new IOException("stan: invalid connection");
        }
        try {
            String hbInbox = nc.newInbox();
            this.hbCallback = msg -> this.processHeartBeat(msg);
            this.hbSubscription = nc.subscribe(hbInbox, this.hbCallback);
            String discoverSubject = String.format("%s.%s", this.opts.getDiscoverPrefix(), this.clusterId);
            ConnectRequest req = ConnectRequest.newBuilder().setClientID(this.clientId).setHeartbeatInbox(hbInbox).build();
            byte[] bytes = req.toByteArray();
            io.nats.client.Message reply = nc.request(discoverSubject, bytes, this.opts.getConnectTimeout().toMillis());
            if (reply == null) {
                throw new IOException("stan: connect request timeout");
            }
            ConnectResponse cr = ConnectResponse.parseFrom(reply.getData());
            if (!cr.getError().isEmpty()) {
                throw new IOException(cr.getError());
            }
            this.pubPrefix = cr.getPubPrefix();
            this.subRequests = cr.getSubRequests();
            this.unsubRequests = cr.getUnsubRequests();
            this.subCloseRequests = cr.getSubCloseRequests();
            this.closeRequests = cr.getCloseRequests();
            this.ackSubject = String.format("%s.%s", "_STAN.acks", NUID.nextGlobal());
            this.ackSubscription = nc.subscribe(this.ackSubject, (io.nats.client.Message msg) -> this.processAck(msg));
            this.ackSubscription.setPendingLimits(1026, 32770);
            this.pubAckMap = new HashMap<String, AckClosure>();
            this.subMap = new HashMap<String, Subscription>();
            this.pubAckChan = new LinkedBlockingQueue<PubAck>(this.opts.getMaxPubAcksInFlight());
        }
        catch (IOException e) {
            exThrown = true;
            if ("nats: timeout".equals(e.getMessage())) {
                throw new IOException("stan: connect request timeout", e);
            }
            throw e;
        }
        finally {
            if (exThrown) {
                try {
                    this.close();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    Connection createNatsConnection() throws IOException {
        Connection nc = null;
        if (this.getNatsConnection() == null) {
            if (this.opts.getNatsUrl() != null) {
                io.nats.client.Options natsOpts = new Options.Builder().name(this.clientId).build();
                nc = Nats.connect(this.opts.getNatsUrl(), natsOpts);
            } else {
                nc = Nats.connect();
            }
            this.ncOwned = true;
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, InterruptedException {
        this.lock();
        try {
            if (this.getNatsConnection() == null) {
                return;
            }
            Connection nc = this.getNatsConnection();
            try {
                CloseResponse cr;
                CloseRequest req;
                byte[] bytes;
                io.nats.client.Message reply;
                this.setNatsConnection(null);
                if (this.getAckSubscription() != null) {
                    try {
                        this.getAckSubscription().unsubscribe();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.getHbSubscription() != null) {
                    try {
                        this.getHbSubscription().unsubscribe();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((reply = nc.request(this.closeRequests, bytes = (req = CloseRequest.newBuilder().setClientID(this.clientId).build()).toByteArray(), this.opts.getConnectTimeout().toMillis())) == null) {
                    throw new IOException("stan: close request timeout");
                }
                if (reply.getData() != null && !(cr = CloseResponse.parseFrom(reply.getData())).getError().isEmpty()) {
                    throw new IOException(cr.getError());
                }
            }
            finally {
                if (this.ncOwned) {
                    try {
                        nc.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    AckClosure createAckClosure(AckHandler ah, BlockingQueue<String> ch) {
        return new AckClosure(ah, ch);
    }

    private SubscriptionImpl createSubscription(String subject, String qgroup, MessageHandler cb, StreamingConnectionImpl conn, SubscriptionOptions opts) {
        return new SubscriptionImpl(subject, qgroup, cb, conn, opts);
    }

    void processHeartBeat(io.nats.client.Message msg) {
        this.rLock();
        Connection nc = this.nc;
        this.rUnlock();
        if (nc != null) {
            try {
                nc.publish(msg.getReplyTo(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    BlockingQueue<String> createErrorChannel() {
        return new LinkedBlockingQueue<String>();
    }

    @Override
    public void publish(String subject, byte[] data) throws IOException, InterruptedException {
        BlockingQueue<String> ch = this.createErrorChannel();
        this.publish(subject, data, null, ch);
        try {
            String err = ch.take();
            if (!err.isEmpty()) {
                throw new IOException(err);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String publish(String subject, byte[] data, AckHandler ah) throws IOException, InterruptedException {
        return this.publish(subject, data, ah, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String publish(String subject, byte[] data, AckHandler ah, BlockingQueue<String> ch) throws IOException, InterruptedException {
        BlockingQueue<PubAck> pac;
        Duration ackTimeout;
        String ackSubject;
        byte[] bytes;
        String guid;
        String subj;
        AckClosure a = this.createAckClosure(ah, ch);
        this.lock();
        try {
            if (this.getNatsConnection() == null) {
                throw new IllegalStateException("stan: connection closed");
            }
            subj = this.pubPrefix + "." + subject;
            guid = NUID.nextGlobal();
            PubMsg.Builder pb = PubMsg.newBuilder().setClientID(this.clientId).setGuid(guid).setSubject(subject);
            if (data != null) {
                pb = pb.setData(ByteString.copyFrom(data));
            }
            PubMsg pe = pb.build();
            bytes = pe.toByteArray();
            this.pubAckMap.put(guid, a);
            ackSubject = this.ackSubject;
            ackTimeout = this.opts.getAckTimeout();
            pac = this.pubAckChan;
        }
        finally {
            this.unlock();
        }
        try {
            pac.put(PubAck.getDefaultInstance());
        }
        catch (InterruptedException pb) {
            // empty catch block
        }
        try {
            this.nc.publish(subj, ackSubject, bytes, true);
        }
        catch (IOException e) {
            this.removeAck(guid);
            throw e;
        }
        this.lock();
        try {
            a.ackTask = this.createAckTimerTask(guid);
            this.ackTimer.schedule(a.ackTask, ackTimeout.toMillis());
        }
        finally {
            this.unlock();
        }
        return guid;
    }

    @Override
    public Subscription subscribe(String subject, MessageHandler cb) throws IOException, InterruptedException {
        return this.subscribe(subject, cb, null);
    }

    @Override
    public Subscription subscribe(String subject, MessageHandler cb, SubscriptionOptions opts) throws IOException, InterruptedException {
        return this.subscribe(subject, null, cb, opts);
    }

    @Override
    public Subscription subscribe(String subject, String queue, MessageHandler cb) throws IOException, InterruptedException {
        return this.subscribe(subject, queue, cb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subscription subscribe(String subject, String queue, MessageHandler cb, SubscriptionOptions opts) throws IOException, InterruptedException {
        Connection nc;
        SubscriptionImpl sub;
        this.lock();
        try {
            if (this.getNatsConnection() == null) {
                throw new IllegalStateException("stan: connection closed");
            }
            sub = this.createSubscription(subject, queue, cb, this, opts);
            this.subMap.put(sub.inbox, sub);
            nc = this.getNatsConnection();
        }
        finally {
            this.unlock();
        }
        sub.wLock();
        try {
            SubscriptionResponse response;
            sub.inboxSub = nc.subscribe(sub.inbox, this);
            SubscriptionRequest sr = this.createSubscriptionRequest(sub);
            io.nats.client.Message reply = nc.request(this.subRequests, sr.toByteArray(), 2L, TimeUnit.SECONDS);
            if (reply == null) {
                sub.inboxSub.unsubscribe();
                throw new IOException("stan: subscribe request timeout");
            }
            try {
                response = SubscriptionResponse.parseFrom(reply.getData());
            }
            catch (InvalidProtocolBufferException e) {
                sub.inboxSub.unsubscribe();
                throw e;
            }
            if (!response.getError().isEmpty()) {
                sub.inboxSub.unsubscribe();
                throw new IOException(response.getError());
            }
            sub.setAckInbox(response.getAckInbox());
        }
        finally {
            sub.wUnlock();
        }
        return sub;
    }

    SubscriptionRequest createSubscriptionRequest(SubscriptionImpl sub) {
        SubscriptionOptions subOpts = sub.getOptions();
        SubscriptionRequest.Builder srb = SubscriptionRequest.newBuilder();
        String clientId = sub.getConnection().getClientId();
        String queue = sub.getQueue();
        String subject = sub.getSubject();
        srb.setClientID(clientId).setSubject(subject).setQGroup(queue == null ? "" : queue).setInbox(sub.getInbox()).setMaxInFlight(subOpts.getMaxInFlight()).setAckWaitInSecs((int)subOpts.getAckWait().getSeconds());
        switch (subOpts.getStartAt()) {
            case First: {
                break;
            }
            case LastReceived: {
                break;
            }
            case NewOnly: {
                break;
            }
            case SequenceStart: {
                srb.setStartSequence(subOpts.getStartSequence());
                break;
            }
            case TimeDeltaStart: {
                long delta = ChronoUnit.NANOS.between(subOpts.getStartTime(), Instant.now());
                srb.setStartTimeDelta(delta);
                break;
            }
        }
        srb.setStartPosition(subOpts.getStartAt());
        if (subOpts.getDurableName() != null) {
            srb.setDurableName(subOpts.getDurableName());
        }
        return srb.build();
    }

    void processAck(io.nats.client.Message msg) {
        PubAck pa;
        IOException ex = null;
        try {
            pa = PubAck.parseFrom(msg.getData());
        }
        catch (InvalidProtocolBufferException e) {
            System.err.println("Protocol error: " + e.getStackTrace());
            return;
        }
        AckClosure ackClosure = this.removeAck(pa.getGuid());
        if (ackClosure != null) {
            String ackError = pa.getError();
            if (ackClosure.ah != null) {
                if (!ackError.isEmpty()) {
                    ex = new IOException(ackError);
                }
                ackClosure.ah.onAck(pa.getGuid(), ex);
            } else if (ackClosure.ch != null) {
                try {
                    ackClosure.ch.put(ackError);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    TimerTask createAckTimerTask(final String guid) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    StreamingConnectionImpl.this.processAckTimeout(guid);
                }
                catch (Exception e) {
                    this.cancel();
                }
            }
        };
    }

    void processAckTimeout(String guid) {
        AckClosure ackClosure = this.removeAck(guid);
        if (ackClosure == null) {
            return;
        }
        if (ackClosure.ah != null) {
            ackClosure.ah.onAck(guid, new TimeoutException("stan: publish ack timeout"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AckClosure removeAck(String guid) {
        BlockingQueue<PubAck> pac;
        AckClosure ackClosure;
        TimerTask timerTask = null;
        this.lock();
        try {
            ackClosure = this.pubAckMap.get(guid);
            if (ackClosure != null) {
                timerTask = ackClosure.ackTask;
                this.pubAckMap.remove(guid);
            }
            pac = this.pubAckChan;
        }
        finally {
            this.unlock();
        }
        if (timerTask != null) {
            timerTask.cancel();
        }
        if (ackClosure != null && pac.size() > 0) {
            try {
                pac.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return ackClosure;
    }

    @Override
    public void onMessage(io.nats.client.Message msg) {
        this.processMsg(msg);
    }

    Message createStanMessage(MsgProto msgp) {
        return new Message(msgp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMsg(io.nats.client.Message raw) {
        StreamingConnectionImpl subsc;
        boolean isManualAck;
        String ackSubject;
        MessageHandler cb;
        SubscriptionImpl sub;
        boolean isClosed;
        Connection nc;
        Message stanMsg = null;
        try {
            MsgProto msgp = MsgProto.parseFrom(raw.getData());
            stanMsg = this.createStanMessage(msgp);
        }
        catch (InvalidProtocolBufferException msgp) {
            // empty catch block
        }
        this.lock();
        try {
            nc = this.getNatsConnection();
            isClosed = nc == null;
            sub = (SubscriptionImpl)this.subMap.get(raw.getSubject());
        }
        finally {
            this.unlock();
        }
        if (sub == null || isClosed) {
            return;
        }
        stanMsg.setSubscription(sub);
        sub.rLock();
        try {
            cb = sub.getMessageHandler();
            ackSubject = sub.getAckInbox();
            isManualAck = sub.getOptions().isManualAcks();
            subsc = sub.getConnection();
        }
        finally {
            sub.rUnlock();
        }
        if (cb != null && subsc != null) {
            cb.onMessage(stanMsg);
        }
        if (!isManualAck) {
            Ack ack = Ack.newBuilder().setSubject(stanMsg.getSubject()).setSequence(stanMsg.getSequence()).build();
            try {
                nc.publish(ackSubject, ack.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public Connection getNatsConnection() {
        return this.nc;
    }

    private void setNatsConnection(Connection nc) {
        this.nc = nc;
    }

    public String newInbox() {
        return this.nc.newInbox();
    }

    void lock() {
        this.mu.writeLock().lock();
    }

    void unlock() {
        this.mu.writeLock().unlock();
    }

    private void rLock() {
        this.mu.readLock().lock();
    }

    private void rUnlock() {
        this.mu.readLock().unlock();
    }

    io.nats.client.Subscription getAckSubscription() {
        return this.ackSubscription;
    }

    io.nats.client.Subscription getHbSubscription() {
        return this.hbSubscription;
    }

    void setPubAckChan(BlockingQueue<PubAck> ch) {
        this.pubAckChan = ch;
    }

    BlockingQueue<PubAck> getPubAckChan() {
        return this.pubAckChan;
    }

    void setPubAckMap(Map<String, AckClosure> map) {
        this.pubAckMap = map;
    }

    Map<String, AckClosure> getPubAckMap() {
        return this.pubAckMap;
    }

    void setSubMap(Map<String, Subscription> map) {
        this.subMap = map;
    }

    Map<String, Subscription> getSubMap() {
        return this.subMap;
    }

    class AckClosure {
        TimerTask ackTask;
        AckHandler ah;
        BlockingQueue<String> ch;

        AckClosure(AckHandler ah, BlockingQueue<String> ch) {
            this.ah = ah;
            this.ch = ch;
        }
    }
}

